Public Class Form1
	Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

	Public Sub New()
		MyBase.New()

		'This call is required by the Windows Form Designer.
		InitializeComponent()

		'Add any initialization after the InitializeComponent() call

	End Sub

	'Form overrides dispose to clean up the component list.
	Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
		If disposing Then
			If Not (components Is Nothing) Then
				components.Dispose()
			End If
		End If
		MyBase.Dispose(disposing)
	End Sub
	Friend WithEvents MainMenu1 As System.Windows.Forms.MainMenu
	Friend WithEvents MenuItem1 As System.Windows.Forms.MenuItem
	Friend WithEvents MenuItem2 As System.Windows.Forms.MenuItem
	Friend WithEvents MenuItem3 As System.Windows.Forms.MenuItem
	Friend WithEvents MenuItem4 As System.Windows.Forms.MenuItem
	Friend WithEvents MenuItem5 As System.Windows.Forms.MenuItem
	Friend WithEvents MenuItem6 As System.Windows.Forms.MenuItem
	Friend WithEvents MenuItem7 As System.Windows.Forms.MenuItem
	Friend WithEvents MenuItem8 As System.Windows.Forms.MenuItem
	Friend WithEvents MenuItem9 As System.Windows.Forms.MenuItem
	Friend WithEvents MenuItem10 As System.Windows.Forms.MenuItem
	Friend WithEvents MenuItem11 As System.Windows.Forms.MenuItem
	Friend WithEvents MenuItem12 As System.Windows.Forms.MenuItem
	Friend WithEvents MenuItem13 As System.Windows.Forms.MenuItem
	Friend WithEvents MenuItem14 As System.Windows.Forms.MenuItem
	Private components As System.ComponentModel.IContainer

	'Required by the Windows Form Designer

	'NOTE: The following procedure is required by the Windows Form Designer
	'It can be modified using the Windows Form Designer.  
	'Do not modify it using the code editor.
	<System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
		Me.MenuItem11 = New System.Windows.Forms.MenuItem()
		Me.MenuItem10 = New System.Windows.Forms.MenuItem()
		Me.MenuItem13 = New System.Windows.Forms.MenuItem()
		Me.MenuItem12 = New System.Windows.Forms.MenuItem()
		Me.MainMenu1 = New System.Windows.Forms.MainMenu()
		Me.MenuItem1 = New System.Windows.Forms.MenuItem()
		Me.MenuItem2 = New System.Windows.Forms.MenuItem()
		Me.MenuItem3 = New System.Windows.Forms.MenuItem()
		Me.MenuItem4 = New System.Windows.Forms.MenuItem()
		Me.MenuItem5 = New System.Windows.Forms.MenuItem()
		Me.MenuItem6 = New System.Windows.Forms.MenuItem()
		Me.MenuItem7 = New System.Windows.Forms.MenuItem()
		Me.MenuItem8 = New System.Windows.Forms.MenuItem()
		Me.MenuItem9 = New System.Windows.Forms.MenuItem()
		Me.MenuItem14 = New System.Windows.Forms.MenuItem()
		'
		'MenuItem11
		'
		Me.MenuItem11.Index = 7
		Me.MenuItem11.Text = "Draw Pi&e"
		'
		'MenuItem10
		'
		Me.MenuItem10.Index = 6
		Me.MenuItem10.Text = "Draw Pol&ygon"
		'
		'MenuItem13
		'
		Me.MenuItem13.Index = 0
		Me.MenuItem13.Text = "&Bezier"
		'
		'MenuItem12
		'
		Me.MenuItem12.Index = 2
		Me.MenuItem12.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItem13, Me.MenuItem14})
		Me.MenuItem12.Text = "&Advanced Draw"
		'
		'MainMenu1
		'
		Me.MainMenu1.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItem1, Me.MenuItem3, Me.MenuItem12})
		'
		'MenuItem1
		'
		Me.MenuItem1.Index = 0
		Me.MenuItem1.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItem2})
		Me.MenuItem1.Text = "&File"
		'
		'MenuItem2
		'
		Me.MenuItem2.Index = 0
		Me.MenuItem2.Text = "E&xit"
		'
		'MenuItem3
		'
		Me.MenuItem3.Index = 1
		Me.MenuItem3.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItem4, Me.MenuItem5, Me.MenuItem6, Me.MenuItem7, Me.MenuItem8, Me.MenuItem9, Me.MenuItem10, Me.MenuItem11})
		Me.MenuItem3.Text = "&Draw"
		'
		'MenuItem4
		'
		Me.MenuItem4.Index = 0
		Me.MenuItem4.Text = "&Rectangle"
		'
		'MenuItem5
		'
		Me.MenuItem5.Index = 1
		Me.MenuItem5.Text = "&Ellipse"
		'
		'MenuItem6
		'
		Me.MenuItem6.Index = 2
		Me.MenuItem6.Text = "&Arc"
		'
		'MenuItem7
		'
		Me.MenuItem7.Index = 3
		Me.MenuItem7.Text = "&Text"
		'
		'MenuItem8
		'
		Me.MenuItem8.Index = 4
		Me.MenuItem8.Text = "&Icon"
		'
		'MenuItem9
		'
		Me.MenuItem9.Index = 5
		Me.MenuItem9.Text = "Graphics Path"
		'
		'MenuItem14
		'
		Me.MenuItem14.Index = 1
		Me.MenuItem14.Text = "GraphicsPath.Reverse"
		'
		'Form1
		'
		Me.AutoScaleBaseSize = New System.Drawing.Size(6, 15)
		Me.BackColor = System.Drawing.SystemColors.Window
		Me.ClientSize = New System.Drawing.Size(536, 472)
		Me.Menu = Me.MainMenu1
		Me.Name = "Form1"
		Me.Text = "Graphics Demo"

	End Sub

#End Region

	Private Sub MenuItem2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItem2.Click
		Application.Exit()
	End Sub

	Private Delegate Sub Draw(ByVal G As Graphics)

	Private Sub MenuItem4_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItem4.Click
		PerformDraw(AddressOf DrawRectangle)
	End Sub

	Private Sub PerformDraw(ByVal DrawProc As Draw)
		Refresh()

		Dim G As Graphics = CreateGraphics()
		'Dim G As Graphics = Graphics.FromHwnd(Handle)
		Try
			DrawProc(G)
		Finally
			G.Dispose()
		End Try
	End Sub

	Private Sub DrawRectangle(ByVal G As Graphics)
		G.DrawRectangle(Pens.Red, 10, 10, 100, 50)
		G.DrawRectangle(Pens.Blue, New Rectangle(15, 15, 90, 40))
	End Sub

	Private Sub DrawEllipse(ByVal G As Graphics)
		G.DrawEllipse(Pens.Blue, 10, 10, 100, 50)
		G.DrawEllipse(Pens.Red, New Rectangle(15, 15, 90, 40))
	End Sub

	Private Sub MenuItem5_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItem5.Click
		PerformDraw(AddressOf DrawEllipse)
	End Sub

	Private Sub DrawArc(ByVal G As Graphics)

		Const Max As Integer = 36
		Dim I As Integer
		For I = 1 To Max
			G.DrawArc(Pens.Red, RandomRect(Max), 0, 180)
		Next

	End Sub

	Private Function GetRandomRect(ByVal Count As Integer) _
		As RectangleF

		Return New RectangleF( _
			(ClientRectangle.Width - (Count * 10)) / 2, _
			10, Count * 10, 300)

	End Function

	Private Function RandomRect( _
	 Optional ByVal Max As Integer = 36) As RectangleF

		Static Count As Integer = 0
		If (Count >= Max) Then Count = 0
		Count += 1
		Return GetRandomRect(Count)

	End Function

	Private Sub MenuItem6_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItem6.Click
		PerformDraw(AddressOf DrawArc)
	End Sub

	Private Sub DrawText(ByVal G As Graphics)
		Dim Image As New Bitmap("..\..\Images\VBNET.jpg")

		Dim ATextureBrush As New TextureBrush(Image)
		Dim AFont As New Font("Garamond", 50, _
			FontStyle.Bold, GraphicsUnit.Pixel, 0)

		G.DrawString("UNLEASHED", AFont, ATextureBrush, 10, 10)
	End Sub

	Private Sub MenuItem7_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItem7.Click
		PerformDraw(AddressOf DrawText)
	End Sub

	Private Sub DrawIcon(ByVal G As Graphics)
		G.DrawIcon(Icon, 10, 10)
	End Sub

	Private Sub MenuItem8_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItem8.Click
		PerformDraw(AddressOf DrawIcon)
	End Sub

	Private Function GetPath() As Drawing2D.GraphicsPath
		' Use function name as temporary and return value!
		GetPath = New Drawing2D.GraphicsPath()

		GetPath.AddString("GOTDOTNET.COM", New FontFamily("Garamond"), _
		 FontStyle.Bold, 40, _
		 New PointF(10, 10), _
		 New StringFormat(StringFormatFlags.DirectionVertical))

	End Function

	Private Sub DrawPath(ByVal G As Graphics)
		G.DrawPath(Pens.DarkGoldenrod, GetPath())
	End Sub

	Private Sub MenuItem9_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItem9.Click
		PerformDraw(AddressOf DrawPath)
	End Sub

	Private Sub ShadowText(ByVal G As Graphics, _
	 ByVal Text As String, ByVal X As Integer, _
	 ByVal Y As Integer)

		G.DrawString(Text, _
		 New Font("Times New Roman", 16, FontStyle.Bold), _
		 Brushes.Silver, X - 3, Y - 3)

		G.DrawString(Text, _
		 New Font("Times New Roman", 16, FontStyle.Bold), _
		 Brushes.Black, X, Y)

	End Sub

	Private Sub Form1_Paint(ByVal sender As Object, _
	 ByVal e As System.Windows.Forms.PaintEventArgs) _
	 Handles MyBase.Paint
		ShadowText(e.Graphics, "GOTDOTNET", 11, _
		 ClientRectangle.Height - 50)
	End Sub

	Private Sub Form1_Load(ByVal sender As System.Object, _
	 ByVal e As System.EventArgs) Handles MyBase.Load
		BackColor = Color.FromName("PapayaWhip")
	End Sub

	Private Sub DrawPolygon(ByVal G As Graphics)

		Dim Points() As Point = {New Point(10, 30), _
		 New Point(100, 10), New Point(150, 75), _
		 New Point(100, 150), New Point(10, 130)}

		G.DrawPolygon(Pens.Purple, Points)

	End Sub

	Private Sub MenuItem10_Click(ByVal sender As System.Object, _
	 ByVal e As System.EventArgs) Handles MenuItem10.Click

		PerformDraw(AddressOf DrawPolygon)

	End Sub

	Private Sub DrawPie(ByVal G As Graphics)
		Dim R As Rectangle = New Rectangle(50, 50, 125, 150)
		Dim B As New TextureBrush(Icon.ToBitmap)

		G.FillPie(B, R, 0, 90)
		G.DrawPie(Pens.Black, R, 0, 270)
	End Sub

	Private Sub MenuItem11_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItem11.Click
		PerformDraw(AddressOf DrawPie)
	End Sub

	Private Overloads Function GetAdjustedCount( _
	 ByVal Size As Integer) As Integer

		While ((Size - 4) Mod 3 <> 0)
			Size -= 1
		End While

		Return Size
	End Function

	Private Overloads Function GetAdjustedCount( _
	 ByVal Source() As PointF) As Integer
		Return GetAdjustedCount(Source.GetUpperBound(0))
	End Function

	Private Sub CopyPoints(ByVal Source() As PointF, _
	 ByRef Target() As PointF)

		ReDim Target(GetAdjustedCount(Source) - 1)
		Array.Copy(Source, Target, Target.Length)
	End Sub

	Private Function GetPath2() As Drawing2D.GraphicsPath
		GetPath2 = New Drawing2D.GraphicsPath()
		GetPath2.AddString(Chr(174), FontFamily.GenericSerif, _
		 FontStyle.Bold, 100, New PointF(50, 50), _
		 StringFormat.GenericDefault)
	End Function

#If False Then
  ' Warps the GraphicsPath
  Private Sub DrawBezier(ByVal G As Graphics)

    Dim Points() As PointF
    Dim Path As Drawing2D.GraphicsPath = GetPath2()
    Dim AMatrix As New Drawing2D.Matrix()

    Dim ARectangle = New RectangleF(0, 0, 100, 200)
    Dim AParallelogram() As PointF = {New PointF(200, 200), _
      New PointF(400, 250), New PointF(220, 400)}

    Path.Warp(AParallelogram, ARectangle, AMatrix, _
      Drawing2D.WarpMode.Perspective, 0.5)

    Path.Widen(Pens.Black)

    CopyPoints(Path.PathPoints, Points)

    G.DrawBeziers(Pens.Red, Points)

  End Sub

#Else
  ' Non-warped version

  Private Sub DrawBezier(ByVal G As Graphics)

    Dim Points() As PointF
    Dim Path As Drawing2D.GraphicsPath = GetPath2()
    Dim AMatrix As New Drawing2D.Matrix()

    AMatrix.Scale(2, 2)
    AMatrix.Invert()
    Path.Transform(AMatrix)
    CopyPoints(Path.PathPoints, Points)
    G.DrawBeziers(Pens.Red, Points)

  End Sub

#End If
  Private Sub MenuItem13_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItem13.Click
    PerformDraw(AddressOf DrawBezier)
  End Sub

  Private Sub MenuItem14_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItem14.Click
    PerformDraw(AddressOf Reverse)
  End Sub

#Region " Translated from C# GraphicsPath.Revser Method Example "

  Private Sub Reverse(ByVal G As Graphics)
    Dim Path As New Drawing2D.GraphicsPath()
    Path.AddLine(New Point(0, 0), New Point(100, 100))
    Path.AddEllipse(100, 100, 200, 250)
    Path.AddArc(300, 250, 100, 100, 0, 90)

    DrawPoints(G, Path.PathPoints, 20)
    Path.Reverse()
    DrawPoints(G, Path.PathPoints, 150)
  End Sub

  Private Sub DrawPoints(ByVal G As Graphics, _
   ByVal Points() As PointF, ByVal Offset As Integer)

    Dim Y As Integer = 20
    Dim I As Integer
    Dim AFont As New Font("Arial", 8)

    For I = 0 To Points.Length - 1
      G.DrawString(Points(I).X.ToString & _
       ", " & Points(I).Y.ToString, AFont, _
       Brushes.Black, Offset, Y)
      Y += 20
    Next

    ' Uncomment to see forward and backwards drawing!
    'G.DrawBeziers(Pens.Blue, Points)

  End Sub

#End Region

End Class
